


# Requirements
For a full list of software packages and version numbers, see the file ```requirement.txt```.

# Usage

### STEP 1: Experiment planning and preprocessing

 Put your raw dataset in the correct folder (nnUNet_raw_data_base/nnUNet_raw_data/TaskXXX_MYTASK
```bash
python -u e2enet/experiment_planning/nnUNet_plan_and_preprocess.py -t xxx 
```
XXX is the integer identifier associated with your Task name TaskXXX_MYTASK.

### STEP 2: Model training

We trains E2ENet in a 5-fold cross-validation, as nnUNet. 
```bash
python -u simple_main.py --task XXX --network 3d_fullres --Tconv shiftConvPP --fold $fold --max_num_epochs 1000 
--num_batches_per_epoch 250 --sparse True --sparse_init uniform --growth random --density $density
--fix False --update_frequency 1200 --death-rate 0.5 
```

$fold specifies which fold of the 5-fold-cross-validaton is trained. $density is the density of E2ENet (e.g., 0.2)

**Notice**: please assign the path for 'network_training_output_dir_base' in paths.py before training. 

### STEP 3: Segemtation results predicting

- Segemtation results predicting for specific fold
```bash
python -u simple_predict.py -f $fold -o $OUTPUT_FOLDER/fold_$fold -m 3d_fullres -t XXX --Tconv shiftConvPP
```

- Segmentation results predicted based on the ensembling of 5 folds
```bash
python -u simple_predict.py -o $OUTPUT_FOLDER -m 3d_fullres -t XXX --Tconv shiftConvPP
```
### STEP 4: Results evaluating on the provided metrics

```bash
python -u evaluator.py -ref nnUNet_raw_data_base/nnUNet_raw_data/TaskXXX/labelsVa -pred $OUTPUT_FOLDER
```

# Acknowledgements
Our code is based on the [nnUNetV1](https://github.com/MIC-DKFZ/nnUNet/tree/nnunetv1)  framework.
